////////////////////////////////////////////////
//
//     -- Mikael Beckius 2009 --
//
////////////////////////////////////////////////

#include <e32cmn.h>
#include <e32debug.h>
#include <gles\egl.h>
#include <gles\gl.h>
#include <gles\glext.h>

#include "bectech256x256.h"

#ifndef GL_BGRA
#define GL_BGRA  0x80E1
#endif

GLuint fb,depth_rb,tex;

struct vertexV2 {
	float x;
	float y;
};

struct vertexT2{
	float s;
	float t;
};

static float vertices1[] = {
	0, 0, 1.0f,   25, 25, 25,  0, 0, 1.0f, -25, 25, 25,  0, 0, 1.0f,  25,-25, 25,  0, 0, 1.0f,  -25,-25, 25, // front
		0, 0,-1.0f,  -25, 25,-25,  0, 0,-1.0f,  25, 25,-25,  0, 0,-1.0f, -25,-25,-25,  0, 0,-1.0f,  25,-25,-25,  // back
		-1.0f, 0, 0, -25, 25, 25, -1.0f, 0, 0, -25, 25,-25, -1.0f, 0, 0, -25,-25, 25, -1.0f, 0, 0,  -25,-25,-25, // left
		1.0f, 0, 0,   25, 25,-25,  1.0f, 0, 0,  25, 25, 25,  1.0f, 0, 0,  25,-25,-25,  1.0f, 0, 0,   25,-25, 25, // right
		0, 1.0f, 0,   25, 25,-25,  0, 1.0f, 0, -25, 25,-25,  0, 1.0f, 0,  25, 25, 25,  0, 1.0f, 0,  -25, 25, 25, // top
		0,-1.0f, 0,   25,-25, 25,  0,-1.0f, 0, -25,-25, 25,  0, -1.0f, 0, 25,-25,-25,  0, -1.0f, 0, -25,-25,-25  // bottom
}; 

static vertexV2 *vertices2 = 0;

static float textureCoords1[] = {
	1, 0, 0, 0, 1, 1, 0, 1,
		1, 0, 0, 0, 1, 1, 0, 1,
		1, 0, 0, 0, 1, 1, 0, 1,
		1, 0, 0, 0, 1, 1, 0, 1,
		1, 0, 0, 0, 1, 1, 0, 1,
		1, 0, 0, 0, 1, 1, 0, 1 
};

static vertexT2 *texCoords2 = 0;

static short g_indices1[24] =  {
	0,1,2,3, 4,5,6,7, 8,9,10,11, 12,13,14,15, 16,17,18,19, 20,21,22,23
};

int main(int args,char** argv){
	unsigned frame = 0;
	int width = 360;
	int height = 640;
	int widthFBO = 256;
	int heightFBO = 256;

	TTime beginTime;
	TTime endTime;
	EGLDisplay dpy;
	EGLSurface surface;
	EGLContext context;
	EGLConfig configs[1];
	EGLint config_count;
	EGLint major, minor; 
	EGLint attribs[] = {
		EGL_SURFACE_TYPE,EGL_WINDOW_BIT,
			EGL_RED_SIZE,8,
			EGL_GREEN_SIZE,8,
			EGL_BLUE_SIZE,8,
			EGL_ALPHA_SIZE,8,
			EGL_DEPTH_SIZE,16,
			EGL_NONE
	};

	texCoords2 = new vertexT2[4];
	texCoords2[0].s=texCoords2[2].s=0.0f;
	texCoords2[0].t=texCoords2[1].t=1;
	texCoords2[1].s=texCoords2[3].s=1;
	texCoords2[2].t=texCoords2[3].t=0.0f;

	vertices2 = new vertexV2[4];
	vertices2[0].x=-(float)widthFBO/2;
	vertices2[0].y=-(float)heightFBO/2;
	vertices2[1].x=(float)widthFBO/2;
	vertices2[1].y=-(float)heightFBO/2;
	vertices2[3].x=(float)widthFBO/2;
	vertices2[3].y=(float)heightFBO/2;
	vertices2[2].x=-(float)widthFBO/2;
	vertices2[2].y=(float)heightFBO/2;

	dpy = eglGetDisplay (EGL_DEFAULT_DISPLAY);
	eglInitialize(dpy, &major, &minor);
	eglGetConfigs (dpy, configs, 1, &config_count);
	eglChooseConfig (dpy, attribs, configs, 1, &config_count);
	surface = eglCreateWindowSurface (dpy, configs[0], 0, 0);
	context = eglCreateContext (dpy, configs[0], EGL_NO_CONTEXT, 0);
	eglMakeCurrent (dpy, surface, surface, context);

	PFNGLBINDFRAMEBUFFEROESPROC glBindFramebufferOES;
	PFNGLDELETEFRAMEBUFFERSOESPROC glDeleteFramebuffersOES;
	PFNGLGENFRAMEBUFFERSOESPROC glGenFramebuffersOES;
	PFNGLFRAMEBUFFERTEXTURE2DOESPROC glFramebufferTexture2DOES;

	glBindFramebufferOES = (PFNGLBINDFRAMEBUFFEROESPROC)eglGetProcAddress("glBindFramebufferOES");
	glDeleteFramebuffersOES = (PFNGLDELETEFRAMEBUFFERSOESPROC)eglGetProcAddress("glDeleteFramebuffersOES");
	glGenFramebuffersOES = (PFNGLGENFRAMEBUFFERSOESPROC)eglGetProcAddress("glGenFramebuffersOES");
	glFramebufferTexture2DOES = (PFNGLFRAMEBUFFERTEXTURE2DOESPROC)eglGetProcAddress("glFramebufferTexture2DOES");

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);

	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);

	glEnable(GL_LIGHT0);
	glShadeModel(GL_SMOOTH);
	glEnable(GL_CULL_FACE);
	glCullFace(GL_BACK);

	glEnable(GL_NORMALIZE);
	glLightModelf(GL_LIGHT_MODEL_TWO_SIDE,GL_TRUE);

	GLfloat spec[] = {0.5f,0.5f,0.5f,0.5f};
	GLfloat amb[] = {0.05f,0.05f,0.05f,1.0f};
	GLfloat dif[] = {0.9f,0.9f,0.9f,1.0f};
	GLfloat lightPos[] = {-16.0f,0.0f,70.0f,0.0f};

	glLightfv(GL_LIGHT0,GL_AMBIENT, amb);
	glLightfv(GL_LIGHT0,GL_SPECULAR, spec);
	glLightfv(GL_LIGHT0,GL_DIFFUSE, dif);
	glLightfv(GL_LIGHT0,GL_POSITION,lightPos);

	float specular[] = {0.9f, 0.9f, 0.9f,1.0f};
	float diffuse[] = {0.8f, 0.8f, 0.8f, 1.0f};
	float ambient[] = {0.16f, 0.16f, 0.16f, 0.5f};

	glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,specular);
	glMaterialfv(GL_FRONT_AND_BACK,GL_DIFFUSE,diffuse);
	glMaterialfv(GL_FRONT_AND_BACK,GL_AMBIENT,ambient);
	glMaterialf(GL_FRONT_AND_BACK,GL_SHININESS,108.0f);

	glGenFramebuffersOES(1,&fb);
	glGenTextures(1, &tex);              // texture
	glBindTexture(GL_TEXTURE_2D, tex);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, widthFBO,heightFBO, 0,GL_RGBA, GL_UNSIGNED_BYTE,NULL);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR); 
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glBindFramebufferOES(GL_FRAMEBUFFER_OES, fb);
	glFramebufferTexture2DOES(GL_FRAMEBUFFER_OES,GL_COLOR_ATTACHMENT0_OES, GL_TEXTURE_2D, tex, 0);

	GLuint id;
	glGenTextures(1,&id);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D,id);
	glPixelStorei(GL_UNPACK_ALIGNMENT,1);
	glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexImage2D(GL_TEXTURE_2D,0,GL_BGRA,256,256,0,GL_BGRA,GL_UNSIGNED_BYTE,imageBectech);
	glBindFramebufferOES(GL_FRAMEBUFFER_OES,0);

	while(++frame<4500){
		glBindFramebufferOES(GL_FRAMEBUFFER_OES, fb);
		glBindTexture(GL_TEXTURE_2D,id);
		glColor4f( 1.0, 1.0, 1.0, 1.0);
		glClearColor(0.0, 0.0, 1.0, 1.0);
		glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
		glViewport(0,0,widthFBO,heightFBO);
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glOrthof(-widthFBO/2,widthFBO/2,-heightFBO/2,heightFBO/2,-1000.0,1000.0);
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glRotatef(frame,0,1,0);
		glRotatef(frame*2,1,0,0);
		glScalef(3.25f,3.25f,3.25f);

		glEnable(GL_DEPTH_TEST);
		glEnable(GL_LIGHTING);
		glDepthFunc(GL_LEQUAL);
		glColor4f(1.0f,1.0f,1.0f,1.0f);
		glTexCoordPointer(2,GL_FLOAT,0,textureCoords1);
		glEnableClientState(GL_NORMAL_ARRAY);
		glNormalPointer(GL_FLOAT,24,vertices1);
		glVertexPointer(3,GL_FLOAT,24,vertices1+3);

		for(int i=0;i<24;i+=4)
			glDrawElements(GL_TRIANGLE_STRIP,4,GL_UNSIGNED_SHORT,g_indices1+i);

		glDisableClientState(GL_NORMAL_ARRAY);
		glDisable(GL_LIGHTING);
		glDisable(GL_DEPTH_TEST);
		glBindFramebufferOES(GL_FRAMEBUFFER_OES, 0);

		glClearColor(0.0, 0.0, 0.0, 1.0);
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		glViewport(0,0,width,height);
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glOrthof(-width/2,width/2,-height/2,height/2,-1000.0,1000.0);
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glColor4f(0.0, 1.0, 1.0,1.0f); 
		glBindTexture(GL_TEXTURE_2D,tex);
		glRotatef(-0.4*frame,0,0,1);
		glColor4f(1.0f,1.0f,1.0f,0.5f);
		glVertexPointer(2,GL_FLOAT,0,(void*)vertices2);
		glTexCoordPointer(2,GL_FLOAT,0,(void*)texCoords2);
		glDrawArrays(GL_TRIANGLE_STRIP,0,4);
		
		eglSwapInterval(dpy,0);
		eglSwapBuffers(dpy,surface);
		if(!(frame%100)){
			endTime.UniversalTime();
			double time = (double)(endTime.Int64()-beginTime.Int64())/1000000.0;
			RDebug::Printf("%f Hz",100.0/time);
			beginTime.UniversalTime();
		}
	}
	glDeleteFramebuffersOES(1,&fb);
	eglDestroyContext (dpy, context);
	eglDestroySurface (dpy, surface);
	eglMakeCurrent (dpy, EGL_NO_SURFACE, EGL_NO_SURFACE, EGL_NO_CONTEXT);
	eglTerminate (dpy);
	delete vertices2;
	delete texCoords2;
	return 0;
}


